/* eslint-disable no-console */
/* eslint-disable no-plusplus */
/* eslint-disable prefer-destructuring */
/* eslint-disable no-else-return */
/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
/* eslint-disable no-undef */
/* eslint-disable no-unused-vars */



class DataLoader {
	constructor(sel, attributes) {
		this.sel = sel;
		this.curpage = null;
		this.curstart = -1;
		this.curend = -1;
		this.fullLength = -1;
		this.setAttributes(attributes);
		this.fetching = false;
		this.curStartFetching = -1;
		this.curEndFetching = -1;
		this.parentGrid = null;
		this.gridManager = null;
	}

	setAttributes(attributes) {
		this.attributes = attributes;
		this.attributeNames = attributes.map((attr) => attr.name);
		this.filterAttributesText = this.attributeNames.join(',');
	}

	setParentGrid(parentGrid, gridManager) {
		this.parentGrid = parentGrid;
		this.gridManager = gridManager;
	}

	getLength() {
		if (this.fullLength === -1) {
			return 0;
		} else {
			return this.fullLength;
		}
	}

	getItem(index) {
		if (this.curpage == null || index > this.curend || index < this.curstart) {
			if (index >= this.fullLength || index < 0)
				return {};
			const that = this;

			// eslint-disable-next-line no-inner-declarations
			function waitFetching(n, resolve) {
				if (that.fetching && n >= that.curStartFetching && n <= that.curEndFetching) {
					resolve(true);
				}
				else if (that.fetching) {
					setTimeout(() => {
						waitFetching(n, resolve);
					}, 0);
				} else {
					resolve(false);
				}
			}

			waitFetching(index, (alreadyFetchingThatPage) => {
				if (!alreadyFetchingThatPage) {
					const grid = that.parentGrid;
					const gridManager = that.gridManager;
					const sub = 100;
					const add = 200;
					/*
					if (grid != null) {
						const range = grid.getRenderedRange();
						const maxrows = Math.floor((range.bottom - range.top + 1) / 2);
						sub = maxrows;
						add = maxrows * 2;
					}
					*/

					let newstart = index - sub;
					if (newstart < 0)
						newstart = 0;
					let newend = newstart + add;
					if (newend >= that.fullLength)
						newend = that.fullLength - 1;
					that.fetching = true;
					that.curStartFetching = newstart;
					that.curEndFetching = newend;
					that.fetchPage(newstart, newend).then(() => {
						that.fetching = false;
						that.curStartFetching = -1;
						that.curEndFetching = -1;
						if (grid != null)
							gridManager.checkInvalidate(newstart, newend);
						// grid.invalidate();
					});
				}
			});


			return {};
		} else {
			return this.curpage[index - this.curstart];
		}
	}

	async fetchPage(start, end) {
		const that = this;
		const { sel } = that;
		// eslint-disable-next-line no-async-promise-executor
		return new Promise(async (resolve) => {
			if (start < 0)
				start = 0;
			if (end >= that.fullLength)
				end = that.fullLength - 1;
			const collection = await sel.getCollection(start, end - start + 1, that.attributeNames.join(','), { filterAttributes: that.filterAttributesText });
			let data = [];
			if (collection != null) {
				data = collection.map(elem => {
					const row = {};
					that.attributeNames.forEach((attr) => {
						row[attr] = elem[attr];
					});
					return row;
				});
				that.curpage = data;
				that.curstart = start;
				that.curend = end;
			}
			resolve();
		});
	}

	async selHasChanged(newsel) {
		const that = this;
		that.sel = newsel;
		// eslint-disable-next-line no-async-promise-executor
		return new Promise(async (resolve) => {
			that.curpage = null;
			that.curstart = -1;
			that.curend = -1;
			that.fullLength = -1;
			try {
				const len = await that.sel.getLength();
				if (len != null) {
					that.fullLength = len;
					if (len > 0) {
						await that.fetchPage(0, 80);
					}
				}
			}
			catch (err) {
				this.gridManager.errorManager.display('The query could not be completed', err.message);
			}
			resolve();
		});
	}
}




// ----------------------------------------------------------------




function replaceText(text, values) {
	let result = '';
	if (text != null) {
		text.split('{').forEach((subpart) => {
			const twoparts = subpart.split('}');
			if (twoparts.length > 1) {
				const [sourceStr, remainStr] = twoparts;
				const value = values[sourceStr];
				result += value + remainStr;
			} else result += subpart;
		});
	}
	return result;
}

class GridManager {

	constructor(ds, dataclass, $gridelem, $queryElem, $footerElem, catalogManager, errorManager) {
		this.ds = ds;
		this.dataclass = dataclass;
		this.$gridelem = $gridelem;
		this.$queryElem = $queryElem;
		this.$footerElem = $footerElem;
		this.catalogManager = catalogManager;
		this.errorManager = errorManager;
		const layout = this.loadLayout();
		this.displayedAtts = this.buildDefaultAttributeList();
		this.buildColumns(layout);
		if (layout != null && layout.cols != null) {
			this.displayedAtts = layout.cols.map((col) => dataclass.getAttribute(col.attname)).filter(Boolean);
			this.filterAttributesText = this.displayedAtts.map((att) => att.name).join(',');
		}
		this.alreadyInvalidate = false;
		this.invalidateStart = -1;
		this.invalidateEnd = -1;
		this.progressListenerID = this.ds.addProgressListener(this.updateProgressIndicator.bind(this));
		this.curprogress = null;
		this.queryHandler = new QueryHandler();
		this.$progressElem = $queryElem.find('.progressFrame'); // soon obsolete
		this.$progressTextElem = this.$queryElem.find('.thinProgressTitle');
		this.$progressHandleElem = this.$queryElem.find('.thinProgressHandle');
		this.$progressBarElem = this.$queryElem.find('.thinProgressBar');
		this.$progressStopElem = this.$queryElem.find('.thinProgressStop');
		this.$progressStopElem.on('click', this.handleStopProgress.bind(this));

		const userAgent = navigator.userAgent;
		this.isSafari = userAgent.indexOf('Safari') > -1 && userAgent.indexOf('Chrome') === -1;
	}

	getQueryHandler() {
		return this.queryHandler;
	}

	getFilterAttributes() {
		return this.filterAttributesText;
	}

	setAssociatedManagers(formManager, queryManager) {
		this.formManager = formManager;
		this.queryManager = queryManager;
		this.formManager.setQueryHandler(this.queryHandler);
		this.queryManager.setQueryHandler(this.queryHandler);
	}

	loadLayout() {
		return SettingManager.getProperty('gridManager', this.dataclass);
	}


	saveLayout() {

		if (this.grid != null) {
			let layout = this.loadLayout();
			if (layout == null)
				layout = {};

			const columns = this.grid.getColumns();
			layout.cols = columns.map((column) => {
				return {
					width: column.width,
					attname: column.field,
					inputValue: column.inputValue,
					squarePict: column.squarePict,
					inputOper: column.inputOper,
					inputOperCode: column.inputOperCode,
				};

			});
			SettingManager.setProperty('gridManager', layout, this.dataclass);
		}
	}

	convertOperCodeToOper(opercode) {
		const manager = this;
		let result = '==';
		switch (opercode) {
			case 'eq':
				result = '==';
				break;
			case 'ne':
				result = '!=';
				break;
			case 'gt':
				result = '>';
				break;
			case 'lt':
				result = '<';
				break;
			case 'ge':
				result = '>=';
				break;
			case 'le':
				result = '<=';
				break;
			case 'istrue':
				result = 'is true';
				break;
			case 'isfalse':
				result = 'is false';
				break;
			case 'isnull':
				result = 'is null';
				break;
			case 'isnotnull':
				result = 'is not null';
				break;
			default:
				result = '==';
				break;

		}
		return result;
	}

	getProportion() {
		return SettingManager.getProperty('LayoutManager.proportion', this.dataclass);
	}

	setProportion(proportion) {
		SettingManager.setProperty('LayoutManager.proportion', proportion, this.dataclass);
	}

	hideAutoGridScrollBars() {
		if (this.grid != null) {
			this.$gridelem.find('.slick-viewport.slick-viewport-top.slick-viewport-left').css('overflow', '', 'overflow-x', '', 'overflow-y', '');
		}
	}

	handleStopProgress(event) {
		if (this.curprogress != null) {
			this.curprogress.userAbort();
		}
	}

	updateProgressIndicator(command, progress) {
		const $textElem = this.$progressTextElem;
		const $progressHandleElem = this.$progressHandleElem;
		if (command === 'remove') {
			if (progress === this.curprogress) {
				$textElem.html('');
				$progressHandleElem.css('width', '');
				this.setCurProgress(null);
				this.hideProgress();
			}
		} else if (progress === this.curprogress) {
			// this.$progressElem.css('display', 'block');
			this.showProgress();
			let message = replaceText(progress.message, { curValue: progress.curValue, maxValue: progress.maxValue });
			if (progress.title != null && progress.title !== '')
				message = `${progress.title} : ${message}`;
			$textElem.html(message);
			if (progress.maxValue > 0) {
				const ratio = Math.round((progress.curValue * 100) / progress.maxValue);
				$progressHandleElem.css('width', `calc(${ratio}% - 2px)`);
			}
		}
	}

	hideProgress() {
		this.$progressTextElem.addClass('hidden');
		this.$progressBarElem.addClass('hidden');
		this.$progressStopElem.addClass('hidden');
	}

	showProgress() {
		this.$progressTextElem.removeClass('hidden');
		this.$progressBarElem.removeClass('hidden');
		this.$progressStopElem.removeClass('hidden');
	}

	setCurProgress(progress) {
		if (this.curprogress != null) {
			// this.$progressElem.css('display', 'none');
			this.hideProgress();
		}
		this.curprogress = progress;
		this.queryHandler.SetCurrentProgress(progress);
	}

	buildDefaultAttributeList() {
		const { dataclass } = this;
		const atts = dataclass.getAllAttributes();
		const selectedAtts = [];
		for (const e in atts) {
			if (selectedAtts.length < 10) {
				const att = atts[e];
				if ((att.kind === 'storage' || att.kind === 'alias' || att.kind === 'calculated') && att.type !== 'image') {
					selectedAtts.push(att);
				}
			}
		}
		this.filterAttributesText = selectedAtts.map((att) => att.name).join(',');
		return selectedAtts;
	}

	getColumnByAtt(attName) {
		let result = null;
		if (this.grid != null) {
			result = this.grid.getColumns().find((col) => col.field === attName);
		}
		return result;
	}

	getAttIndex(attName) {
		return this.displayedAtts.findIndex((att) => att.name === attName);
	}

	SetPictColumn(attName, square) {
		const colDef = this.getColumnByAtt(attName);
		if (colDef != null) {
			colDef.squarePict = square;
			this.saveLayout();
			// this.grid.render();
			this.grid.invalidate();
		}
	}

	buildColumn(att, layoutCol) {

		this.catalogManager.checkAttribute(att);
		const col = {};
		const dataclass = this.dataclass;
		col.id = att.name;
		col.field = att.name;
		col.name = att.name;
		col.width = 200;
		col.sortable = true;
		col.rerenderOnResize = true;
		col.squarePict = false;
		col.dataClassName = dataclass.getName();
		col.formatter = this.formatter.bind(this);
		switch (att.type) {
			case 'number':
			case 'integer':
			case 'word':
			case 'long':
			case 'long64':
				col.dataType = 'number';
				col.width = 100;
				col.cssClass = 'rightAlign';
				// col.editor = Slick.Editors.Text;
				break;

			case 'duration':
				col.dataType = 'number';
				col.width = 100;
				col.cssClass = 'duration';
				// col.editor = Slick.Editors.Text;
				break;


			case 'date':
				col.dataType = 'date';
				col.width = 150;
				col.cssClass = 'rightAlign';
				// col.editor = Slick.Editors.Date;
				break;

			case 'bool':
			case 'boolean':
				col.width = 80;
				col.dataType = 'boolean';
				col.cssClass = 'checkMarkCell';
				// col.editor = Slick.Editors.Checkbox;
				// col.formatter = Slick.Formatters.Checkmark;
				break;

			case 'object':
				col.sortable = false;
				col.dataType = 'object';
				break;

			case 'image':
				col.sortable = false;
				col.width = 60;
				col.dataType = 'image';
				col.cssClass = 'imageInCellContainer';
				break;

			case 'blob':
				col.sortable = false;
				col.dataType = 'blob';
				break;

			default:
				col.dataType = 'string';
				// col.editor = Slick.Editors.Text;
				break;
		}

		if (layoutCol != null && layoutCol.width != null)
			col.width = layoutCol.width;

		if (layoutCol != null && layoutCol.inputValue != null)
			col.inputValue = layoutCol.inputValue;

		if (layoutCol != null && layoutCol.inputOper != null)
			col.inputOper = layoutCol.inputOper;

		if (layoutCol != null && layoutCol.inputOperCode != null)
			col.inputOperCode = layoutCol.inputOperCode;

		if (layoutCol != null && layoutCol.squarePict != null)
			col.squarePict = layoutCol.squarePict;

		return col;
	}

	toggleAttribute(attName) {
		let result = null;
		const att = this.dataclass.getAttribute(attName);
		if (att != null) {
			const displayedPos = this.getAttIndex(attName);
			if (displayedPos === -1) {
				this.displayedAtts.push(att);
				result = true;
			}
			else {
				this.displayedAtts.splice(displayedPos, 1);
				result = false;
			}
			this.filterAttributesText = this.displayedAtts.map((attr) => attr.name).join(',');
			this.updateColumns(attName, result);

		}
		return result;
	}

	getDisplayedAttributes() {
		const result = {};
		this.displayedAtts.forEach((attr) => {
			result[attr.name] = true;
		});
		return result;
	}

	IsAttributeDisplayed(attName) {
		return this.getAttIndex(attName) !== -1;
	}

	async updateColumns(attName = null, addAtt = false) {
		// console.log(`update columns gridheight: ${this.$gridelem.height()}`);
		const columns = this.grid.getColumns();
		const layout = {};
		layout.cols = columns.map((column) => {
			return {
				width: column.width,
				attname: column.field,
				inputValue: column.inputValue,
				squarePict: column.squarePict,
				inputOper: column.inputOper,
				inputOperCode: column.inputOperCode,
			};
		});
		if (attName != null) {
			if (addAtt)
				layout.cols.push({ attname: attName });
			else
				layout.cols = layout.cols.filter(layoutcol => layoutcol.attname !== attName);
		}

		this.deInstallQueryFooters();
		this.buildColumns(layout);
		this.grid.setColumns(this.columns);
		this.installQueryFooters();
		this.hideAutoGridScrollBars();
		this.dataloader.setAttributes(this.displayedAtts);
		this.saveLayout();
		// this.dataclass.getCache().clearAll();
		if (this.sel != null) {
			this.sel.setFilteredAttributes(this.filterAttributesText);
			await this.dataloader.selHasChanged(this.sel);
			// console.log(`sel has changed gridheight: ${this.$gridelem.height()}`);
			this.grid.setData(this.dataloader, true);
			this.grid.render();
			this.hideAutoGridScrollBars();
		}
	}


	buildColumns(layout = null) {
		const manager = this;
		let cols = [];
		if (layout == null || layout.cols == null) {
			const atts = this.displayedAtts;
			cols = atts.map((att) => {
				const col = manager.buildColumn(att);
				return col;
			});
		} else {
			cols = layout.cols.map((layoutcol) => {
				const att = manager.dataclass.getAttribute(layoutcol.attname);
				if (att != null) {
					return manager.buildColumn(att, layoutcol);
				} else {
					return null;
				}
			}).filter(Boolean);
		}
		this.columns = cols;
	}

	handleSortEvent(e, args) {
		// const manager = this;
		// const { grid, dataloader } = manager;
		let attributes;
		if (args.multiColumnSort) {
			attributes = args.sortCols.map((column) => {
				let attname = column.sortCol.field;
				if (!column.sortAsc)
					attname += ' desc';
				return attname;
			}).join(',');
		} else {
			const attname = args.sortCol.field;
			const asc = args.sortAsc;
			attributes = attname;
			if (!asc)
				attributes += ' desc';
		}
		if (this.sel != null) {
			const progress = this.ds.newProgressIndicator();
			this.setCurProgress(progress);
			this.sel.orderBy(attributes, { progressInfo: progress.getRefID(), maxEntities: true }).then(async (newsel) => {
				await this.setCurrentSelection(newsel);
			}).catch(async (err) => {
				if (!progress.graceFullStop)
					this.errorManager.display('Sorting could not be completed', err.message);
			});
		}
	}

	handleColumnsReordered(/* e, args */) {
		this.deInstallQueryFooters();
		this.installQueryFooters();
		this.hideAutoGridScrollBars();
		this.saveLayout();
	}

	handleColumnsResized(/* e, args */) {
		this.deInstallQueryFooters();
		this.installQueryFooters();
		this.saveLayout();
	}

	formatter(row, cell, value, columnDef, dataContext) {
		const manager = this;
		if (value === null) {
			if (columnDef.dataType === 'image')
				value = '';
			else
				value = '<div class="nullCell">null</div>';
		} else if (columnDef.dataType === 'blob') {
			value = '<div class="blobCell">binary content</div>';
		} else if (columnDef.dataType === 'image') {
			const imgobj = value;
			value = '';
			if (imgobj != null && typeof (imgobj) === 'object') {
				const deferred = imgobj.__deferred;
				if (deferred != null) {
					const uri = deferred.uri;
					const ref = `${columnDef.dataClassName}.${columnDef.field}`;
					if (uri != null) {
						if (columnDef.squarePict)
							value = `<img src="${uri}" class="imageInCell square" data-ref="${ref}">`;
						else
							value = `<img src="${uri}" class="imageInCell rounded" data-ref="${ref}">`;
					}

				}
			}
		} else if (value === null || value === undefined) {
			value = '';
		} else if (value instanceof Date) {
			value = Utils.formatDate(value, 'L');
		} else if (typeof (value) === 'object') {
			value = JSON.stringify(value);
		} else if (typeof (value) === 'boolean') {
			if (value) {
				value = '<div class="checkImage"></div>';
			} else
				value = '';
		} else if (typeof (value) === 'number') {
			if (columnDef.cssClass === 'duration')
				value = Utils.formatDuration(value);
			else
				value = Utils.formatNumber(value, { format: '###,###,###,###,###.####################', overrideGroup: true });
		}

		return value;
	}

	checkInvalidate(start, end) {
		const that = this;
		const { grid } = that;
		if (grid != null) {
			if (that.alreadyInvalidate) {
				if (start < that.invalidateStart || end > that.invalidateEnd) {
					setTimeout(() => {
						that.checkInvalidate(start, end);
					}, 0);
				}
			} else {
				that.alreadyInvalidate = true;
				that.invalidateStart = start;
				that.invalidateEnd = end;
				grid.invalidate();
				that.alreadyInvalidate = false;
			}
		}
	}

	handleSelectedRowsChanged(e, args) {
		const rows = args.rows;
		const manager = this;
		if (rows.length > 0) {
			const curpos = rows[0];
			const sel = this.sel;
			if (sel != null) {
				sel.getEntity(curpos, { forceReloadEntity: true }).then((entity) => {
					if (manager.formManager != null) {
						manager.formManager.fillForm(entity);
					}
				}).catch(async (err) => {
					this.errorManager.display('The selected row could not be loaded', err.message);
				});
			}
		}
	}


	selectRow(rownum) {
		this.grid.setSelectedRows([rownum]);
		this.grid.scrollRowIntoView(rownum);
	}

	selectFirstRow() {
		const len = this.grid.getDataLength();
		if (len > 0) {
			this.selectRow(0);
		}
	}

	selectLastRow() {
		const len = this.grid.getDataLength();
		if (len > 0) {
			this.selectRow(len - 1);
		}
	}

	selectNextRow() {
		const len = this.grid.getDataLength();
		if (len > 0) {
			const rows = this.grid.getSelectedRows();
			if (rows.length > 0) {
				const currow = rows[0];
				if (currow < len - 1) {
					this.selectRow(currow + 1);
				}
			}

		}
	}

	selectPreviousRow() {
		const len = this.grid.getDataLength();
		if (len > 0) {
			const rows = this.grid.getSelectedRows();
			if (rows.length > 0) {
				const currow = rows[0];
				if (currow > 0) {
					this.selectRow(currow - 1);
				}
			}
		}
	}

	toto() {
		this.x = 1;
		switch (this.x) {
			case 'a':
				this.y = 1;
				break;
			default:
				this.z = 2;
				a = [a, b, c, d, e, f];
				break;

		}
	}

	async buildGrid() {
		const manager = this;
		// eslint-disable-next-line no-async-promise-executor
		return new Promise(async (resolve) => {
			const options = {
				multiColumnSort: true,
				// createFooterRow: true,
				// showFooterRow: true,
				// footerRowHeight: 30,
				syncColumnCellResize: true,
				editable: false,
				enableAddRow: false,
				enableCellNavigation: true,
				asyncEditorLoading: false,
				autoEdit: false,
				headerRowHeight: 36,
				rowHeight: 32,
				topPanelHeight: 36,
				preHeaderPanelHeight: 36,
			};
			manager.sel = await manager.dataclass.allEntities({ filterAttributes: manager.filterAttributesText, maxEntities: true });
			if (manager.sel != null) {
				try {
					await manager.sel.getLength(); // to force real query
				}
				catch (err) {
					this.errorManager.display('Could not get entities', err.message);
					manager.sel = manager.dataclass.newEmptySelection();
				}

				const dataloader = new DataLoader(manager.sel, manager.displayedAtts);
				manager.dataloader = dataloader;
				// console.log(`building grid on${  manager.dataclass.getName()}`);
				manager.computeGridHeight();
				const grid = new Slick.Grid(manager.$gridelem, dataloader, manager.columns, options);
				manager.grid = grid;
				dataloader.setParentGrid(grid, manager);
				grid.setSelectionModel(new Slick.RowSelectionModel({ selectActiveRow: true}));
				grid.onSort.subscribe(manager.handleSortEvent.bind(manager));

				grid.onColumnsReordered.subscribe(manager.handleColumnsReordered.bind(manager));
				grid.onColumnsResized.subscribe(manager.handleColumnsResized.bind(manager));
				grid.onSelectedRowsChanged.subscribe(manager.handleSelectedRowsChanged.bind(manager));

				manager.hideAutoGridScrollBars();
				manager.installQueryFooters();
				// window.lrgrid = grid; // for debuging purpose
				await dataloader.selHasChanged(manager.sel);
				grid.setData(dataloader, true);
				// console.log(`build grid sel has changed gridheight: ${this.$gridelem.height()}`);
				grid.render();
				grid.setSelectedRows([]);
				grid.setSelectedRows([0]);
				manager.hideAutoGridScrollBars();
				manager.displaySelLength(manager.sel);

				/*
				const $canvas = manager.$gridelem.find('.grid-canvas.grid-canvas-top.grid-canvas-left');
				$canvas.on('scroll', this.handleScroll.bind(this));
				*/
				const $canvas2 = manager.$gridelem.find('.slick-viewport.slick-viewport-top.slick-viewport-left');
				$canvas2.on('scroll', this.handleScroll.bind(this));
			}
			resolve();
		});
	}

	handleScroll(event) {
		const $queryBar = this.$queryElem.find('.queryInputsBar');
		$queryBar.css('left', `${-event.currentTarget.scrollLeft}px` );
	}

	clearQueryInputs() {
		const manager = this;
		const cols = this.grid.getColumns();
		cols.forEach((col) => {
			col.inputValue = null;
			col.inputOper = null;
			col.inputOperCode = null;
			const $elem = manager.$queryElem.find(`input[data-colID="${col.id}"]`);
			$elem.val('');
			const $selectelem = manager.$queryElem.find(`select[data-colID="${col.id}"]`);
			$selectelem.val('eq');
		});
		this.saveLayout();
	}

	async performQueryFromFooter() {
		const manager = this;
		const cols = this.grid.getColumns();
		const queryParts = [];
		let paramindex = 0;
		cols.forEach((col) => {
			if (col.inputValue != null || col.dataType === 'boolean') {
				let qvalue = col.inputValue;
				const att = manager.dataclass.getAttribute(col.field);
				if (att != null) {
					if ((att.type === 'string' || att.type === 'text' || att.kind === 'alias')) {
						++paramindex;
						const querynode = `(${col.field} == :${paramindex})`;
						qvalue += '@';
						queryParts.push({ querystring: querynode, queryvalue: qvalue });
					} else if (col.dataType === 'number') {
						if (col.inputOper != null) {
							// qvalue = parseFloat(qvalue);
							if (att.type === 'duration') {
								qvalue = Utils.stringToDuration(qvalue);
								if (qvalue != null)
									qvalue /= 1000;
							} else
								qvalue = Utils.stringToNumber(qvalue);
							if (qvalue != null) {
								++paramindex;
								const querynode = `(${col.field} ${col.inputOper} :${paramindex})`;
								queryParts.push({ querystring: querynode, queryvalue: qvalue });
							}
						}
					} else if (col.dataType === 'date') {
						if (col.inputOper != null) {
							// qvalue = Utils.parseDate(qvalue);
							++paramindex;
							const querynode = `(${col.field} ${col.inputOper} :${paramindex})`;
							queryParts.push({ querystring: querynode, queryvalue: qvalue });
						}
					} else if (col.dataType === 'boolean') {
						if (col.inputOper != null) {
							++paramindex;
							const querynode = `(${col.field} ${col.inputOper})`;
							queryParts.push({ querystring: querynode, queryvalue: true });
						}
					}

					/*
						const subparts = qvalue.split(';');
						if (subparts.length === 1) {
							qvalue = parseFloat(qvalue);
							++paramindex;
							const querynode = `(${col.field} == :${paramindex})`;
							queryParts.push({ querystring: querynode, queryvalue: qvalue });
						} else {
							++paramindex;
							let querynode = `(${col.field} >= :${paramindex})`;
							queryParts.push({ querystring: querynode, queryvalue: parseFloat(subparts[0]) });
							++paramindex;
							querynode = `(${col.field} <= :${paramindex})`;
							queryParts.push({ querystring: querynode, queryvalue: parseFloat(subparts[1]) });
						}
						*/

				}
			}
		});

		let newsel = null;
		if (queryParts.length === 0) {
			try {
				newsel = await this.dataclass.allEntities({ filterAttributes: this.filterAttributesText, maxEntities: true });
				await newsel.getLength(); // to force real query
				await this.setCurrentSelection(newsel);
			}
			catch (err) {
				this.errorManager.display('Could not get entities', err.message);
			}
		} else {
			const qstring = queryParts.map((qpart) => qpart.querystring).join(' and ');
			const params = queryParts.map((qpart) => qpart.queryvalue);
			const progress = manager.ds.newProgressIndicator();
			manager.setCurProgress(progress);

			try {
				newsel = await this.dataclass.query(qstring, { progressInfo: progress.getRefID(), queryParams: params, filterAttributes: this.filterAttributesText, maxEntities: true });
				await newsel.getLength(); // to force real query
				await this.setCurrentSelection(newsel);
			}
			catch (err) {
				if (!progress.graceFullStop)
					this.errorManager.display('The query could not be completed', err.message);
			}
		}

	}

	async displaySelLength(sel) {
		const $resultElem = this.$footerElem.find('.rawDisplayFooterValue');
		const len = await sel.getLength();
		$resultElem.html(Utils.formatNumber(len, { format: '###,###,###,###,##0', overrideGroup: true }));
		const maxEntities = sel.getMaxEntities();
		if (maxEntities == null) {
			$resultElem.nextAll().hide();
		} else {
			$resultElem.nextAll().show();
			this.$footerElem.find('.rawDisplayFooterValue2').html(Utils.formatNumber(maxEntities, { format: '###,###,###,###,##0', overrideGroup: true }));
		}
	}

	async setCurrentSelection(newsel) {
		this.sel = newsel;
		await this.dataloader.selHasChanged(newsel);
		this.grid.setData(this.dataloader, true);
		// console.log(`set current selection gridheight: ${this.$gridelem.height()}`);
		this.grid.resizeCanvas();
		this.grid.render();
		this.grid.setSelectedRows([]);
		this.grid.setSelectedRows([0]);
		this.hideAutoGridScrollBars();
		this.displaySelLength(newsel);
	}

	handleQuerySelectEvent(event) {
		const target = event.target;
		const colID = target.getAttribute('data-colID');
		const colpos = this.grid.getColumnIndex(colID);
		if (colpos >= 0) {
			const col = this.grid.getColumns()[colpos];
			if (target.value == null || target.value === 'none') {
				col.inputOper = null;
				col.inputOperCode = null;
			} else {
				col.inputOperCode = target.value;
				col.inputOper = this.convertOperCodeToOper(col.inputOperCode);
			}
			this.saveLayout();
			this.performQueryFromFooter();
		}
	}

	handleQueryEvent(event) {
		const target = event.target;
		const colID = target.getAttribute('data-colID');
		const colpos = this.grid.getColumnIndex(colID);
		if (colpos >= 0) {
			const col = this.grid.getColumns()[colpos];
			if (target.value == null || target.value === '')
				col.inputValue = null;
			else if (col.dataType === 'date') {
				try {
					const d = $.datepicker.parseDate($(target).datepicker('option', 'dateFormat'), target.value);
					col.inputValue = Utils.formatValueForDateInput(d, true);
				}
				catch (err) {
					col.inputValue = '0!0!0';
				}
			} else {
				col.inputValue = target.value;
			}
			if (col.dataType === 'date' || col.dataType === 'number') {
				if (col.inputValue != null) {
					if (col.inputOper == null || col.inputOperCode == null) {
						col.inputOperCode = 'eq';
						col.inputOper = this.convertOperCodeToOper(col.inputOperCode);
					}
				}
			}

			this.saveLayout();
			this.performQueryFromFooter();

		}
	}

	deInstallQueryFooters() {
		if (this.grid != null) {
			const $queryBar = this.$queryElem.find('.queryInputsBar');
			$queryBar.off();
			$queryBar.off('input', '.queryInput');
		}
	}

	installQueryFooters() {
		const manager = this;
		const grid = this.grid;
		if (grid != null) {
			const $queryBar = this.$queryElem.find('.queryInputsBar');
			let html = '';
			let totalWidth = 0;
			const cols = grid.getColumns();
			const nbcols = cols.length;
			cols.forEach((col, index) => {
				totalWidth += col.width;
				let otherclass = ' middle';
				if (index === 0)
					otherclass = ' first';
				else if (index === nbcols - 1)
					otherclass = ' last';
				html += `<div class="queryInputHolder ${otherclass}" style="width:${col.width}px;">`;

				const att = manager.dataclass.getAttribute(col.field);
				if (att != null) {
					switch (att.type) {
						case 'string':
						case 'text':
						case 'uuid':
							html += `<input autocomplete="nope" autocorrect="off" placeholder="${col.name}" data-colID="${col.id}" type="text" class="queryInput text"/>`;
							break;

						case 'number':
						case 'integer':
						case 'word':
						case 'long':
						case 'long64':
						case 'duration':
							html += `<select class="queryInputOperSelector queryInputNumberOperSelector" data-colID="${col.id}">`;
							html += '<option value="eq">=</option>';
							html += '<option value="lt">&lt;</option>';
							html += '<option value="le">&le;</option>';
							html += '<option value="gt">&gt;</option>';
							html += '<option value="ge">&ge;</option>';
							html += '<option value="ne">&ne;</option>';
							html += '</select>';
							html += `<input autocomplete="nope" autocorrect="off" placeholder="${col.name}" data-colID="${col.id}" type="text" class="queryInput number"/>`;
							break;

						case 'date':
							html += `<select class="queryInputOperSelector queryInputDateOperSelector" data-colID="${col.id}">`;
							html += '<option value="eq">=</option>';
							html += '<option value="lt">&lt;</option>';
							html += '<option value="le">&le;</option>';
							html += '<option value="gt">&gt;</option>';
							html += '<option value="ge">&ge;</option>';
							html += '<option value="ne">&ne;</option>';
							html += '</select>';
							html += `<input autocomplete="nope" autocorrect="off" placeholder="${col.name}" data-colID="${col.id}" type="text" class="queryInput date"/>`;
							break;

						case 'bool':
						case 'boolean':
							html += `<select class="queryInputOperSelector queryInputBoolOperSelector" data-colID="${col.id}">`;
							html += '<option value="none"> </option>';
							html += '<option value="istrue">is true</option>';
							html += '<option value="isfalse">is false</option>';
							html += '<option value="isnull">is null</option>';
							html += '<option value="isnotnull">is not null</option>';
							html += '</select>';
							break;

						case 'object':
							break;

						case 'image':
							break;

						case 'blob':
							break;

						default:
							break;
					}

				}

				html += '</div>';
				if (col.inputValue === undefined)
					col.inputValue = null;
			});
			$queryBar.width(totalWidth);
			$queryBar.html(html);
			$queryBar.on('input', '.queryInput.text', this.handleQueryEvent.bind(this));
			$queryBar.on('input', '.queryInput.number', this.handleQueryEvent.bind(this));
			$queryBar.on('change', '.queryInput.date', this.handleQueryEvent.bind(this));
			$queryBar.on('input', '.queryInputOperSelector', this.handleQuerySelectEvent.bind(this));
			cols.forEach((col, index) => {
				const $elem = $queryBar.find(`input[data-colID="${col.id}"]`);
				const att = manager.dataclass.getAttribute(col.field);
				if (att != null) {
					if (col.inputOperCode != null) {
						const $selectelem = $queryBar.find(`select[data-colID="${col.id}"]`);
						$selectelem.val(col.inputOperCode);
					}

					if (att.type === 'date') {
						$.datepicker.setDefaults($.datepicker.regional[Utils.getBrowserLang()]);
						$elem.datepicker();
						if (col.inputValue != null) {
							const d = Utils.parseDate(col.inputValue);
							if (d != null)
								$elem.val( $.datepicker.formatDate($elem.datepicker('option', 'dateFormat'), d) );
						}
					} else if (col.inputValue != null) {
						$elem.val(col.inputValue);
					}
				}
			});
		}

	}

	computeGridHeight() { // because of a bug in Safari
		// console.log(`gridheight: ${this.$gridelem.height()}`);
		if (this.isSafari) {
			this.$gridelem.height(0);
			const $parent = $(this.$gridelem[0].parentElement);
			const h = $parent.height();
			this.$gridelem.height(h - 1);
		}
		if (this.$gridelem.is(':hidden')) {
			// break here
			const x = 1;
		}
	}

	resizeCanvas() {
		if (this.grid != null) {
			this.computeGridHeight();
			this.grid.resizeCanvas();
		}
	}

	getGrid() {
		return this.grid;
	}

	destroy() {
		this.$progressStopElem.off();
		this.formManager = null;
		this.queryManager = null;
		if (this.grid != null) {
			this.deInstallQueryFooters();
			this.grid.destroy();
		}

		if (this.sel != null) {
			this.sel.destroy();
		}

		this.queryHandler.destroy();

		if (this.progressListenerID != null)
			this.ds.removeProgressListener(this.progressListenerID);
	}

}


