/* eslint-disable no-console */
/* eslint-disable no-plusplus */
/* eslint-disable prefer-destructuring */
/* eslint-disable no-else-return */
/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
/* eslint-disable no-undef */
/* eslint-disable no-unused-vars */



class Splitter {
	constructor(catalogManager, $splitElem, $left, $right, gridManager = null) {
		this.$splitElem = $splitElem;
		this.$left = $left;
		this.$right = $right;
		this.catalogManager = catalogManager;
		this.boundup = this.handleMouseUp.bind(this);
		this.boundmove = this.handleMouseMove.bind(this);
		$splitElem.on('mousedown', this.handleMouseDown.bind(this));
		this.isdown = false;
		const gridm = this.catalogManager.getCurrentGridManager();
		if (gridManager != null) {
			const proportion = gridManager.getProportion();
			if (proportion != null) {
				this.setProportion(proportion);
			}
		}
	}


	destroy() {
		this.$splitElem.off();
	}

	handleMouseDown(event) {
		this.isdown = true;
		$('body').on('mouseup', this.boundup);
		$('body').on('mousemove', this.boundmove);
		event.stopImmediatePropagation();
		event.preventDefault();
	}

	handleMouseUp(event) {
		this.isdown = false;
		$('body').off('mouseup', this.boundup);
		$('body').off('mousemove', this.boundmove);
		event.stopImmediatePropagation();
		event.preventDefault();
	}

	handleMouseMove(event) {
		if (this.isdown) {
			let posx = event.originalEvent.clientX - this.$left.offset().left;
			if (posx < 0)
				posx = 0;
			// const posy = event.originalEvent.clientY;
			const maxX = this.$right.width() + this.$left.width() /* - this.$left.offset().left */;
			let proportion = Math.round((posx / maxX) * 10000) / 100;
			if (proportion < 0)
				proportion = 0;
			if (proportion > 100)
				proportion = 100;
			this.setProportion(proportion);
			/*
			this.$left.css('width', `${proportion}%`);
			this.$right.css('width', `${100 - proportion}%`);
			const gridm = this.catalogManager.getCurrentGridManager();
			if (gridm != null) {
				const grid = gridm.getGrid();
				if (grid != null) {
					// this.deInstallQueryFooters();
					grid.resizeCanvas();
					// this.installQueryFooters();
				}
			}
			*/
			event.stopImmediatePropagation();
			event.preventDefault();
		}
	}

	setProportion(proportion) {
		this.catalogManager.saveProportion(proportion);
		this.$left.css('width', `${proportion}%`);
		this.$right.css('width', `${100 - proportion}%`);
		const gridm = this.catalogManager.getCurrentGridManager();
		if (gridm != null) {
			const grid = gridm.getGrid();
			if (grid != null) {
				// this.deInstallQueryFooters();
				grid.resizeCanvas();
				// this.installQueryFooters();
			}
		}
	}
}


// ----------------------------------------------------------------


class DataClassRef {
	constructor(dataclass, $placeHolder, $tabHolder) {
		this.dataclass = dataclass;
		this.$placeHolder = $placeHolder;
		this.$tabHolder = $tabHolder;
	}
}


class CatalogManager {
	constructor(ds, $holder, $contentPlaceHolder, $parentPlaceHolder, $tabsHolder) {
		this.ds = ds;
		this.$dataClassElem = $holder.find('.dataclasses');
		this.$attributeElem = $holder.find('.attributes');
		this.$contentPlaceHolder = $contentPlaceHolder.clone();
		$contentPlaceHolder.hide();
		this.$inputQueryAtt = $holder.find('.attributeQueryInput');
		this.$inputQueryDataClass = $holder.find('.dataclassQueryInput');
		this.$parentPlaceHolder = $parentPlaceHolder;
		this.$tabsHolder = $tabsHolder;
		this.fillDataClasses();
		this.bindEvents();
		this.dataClassRefsByNames = {};
		this.curDataClassName = '';
		this.curDataClassRef = null;

	}

	loadFromSettings() {
		let loaded = false;
		const manager = this;
		const tablist = SettingManager.getProperty('catalogManager.tabs');
		if (tablist != null) {
			manager.buildDataClassRefs(tablist);

			const selectedDataClassName = SettingManager.getProperty('catalogManager.selectedDataClassName');
			if (selectedDataClassName != null) {
				const dataclass = manager.ds.getDataClass(selectedDataClassName);
				if (dataclass != null) {
					loaded = true;
					manager.selectDataClass(dataclass);
				}
			}

		}
		return loaded;
	}

	saveSettings() {
		const tablist = [];
		Object.values(this.dataClassRefsByNames).forEach(dataclassref => {
			tablist.push({ dataClassName: dataclassref.dataclass.getName() });
		});
		SettingManager.setProperty('catalogManager.tabs', tablist);
		SettingManager.setProperty('catalogManager.selectedDataClassName', this.curDataClassName);
	}

	saveProportion(proportion) {
		const gridm = this.getCurrentGridManager();
		if (gridm != null) {
			gridm.setProportion(proportion);
		}
	}

	getProportion() {
		let proportion = null;
		const grimd = this.getCurrentGridManager();
		if (gridm != null) {
			proportion = gridm.getProportion();
		}
		return proportion;
	}

	getCurrentGridManager() {
		let gridm = null;
		if (this.curDataClassName != null) {
			const dataClassRef = this.getDataClassRef(this.curDataClassName);
			if (dataClassRef != null)
				gridm = dataClassRef.gridManager;
		}
		return gridm;
	}

	buildTabHolder(dataclassName) {
		const manager = this;
		let html = '';
		html += '<div class="dataClassTabContainer">';
		html += `<div class="dataClassTab" attr-dataClassName="${dataclassName}">`;
		html += '<span class="preContent"></span>';
		html += `<span class="content">${dataclassName}</span>`;
		html += '<button class="close"> <img src="resources/cancel-gray.svg"> </button>';
		html += '</div>';
		html += '<div class="marker"></div>';
		html += '</div>';
		return $(html);
	}

	closeDataClass(dataclass) {
		const dataclassName = dataclass.getName();
		const foundDataClassRef = this.dataClassRefsByNames[dataclassName];
		if (foundDataClassRef != null) {
			let nextdataclass = null;
			let $next = foundDataClassRef.$tabHolder.next();
			if ($next.length === 0)
				$next = foundDataClassRef.$tabHolder.prev();
			if ($next.length !== 0) {
				const nextdataclassname = $next.find('.dataClassTab').attr('attr-dataClassName');
				nextdataclass = this.ds.getDataClass(nextdataclassname);
			}

			if (dataclassName === this.curDataClassName) {
				this.selectDataClass(nextdataclass);
			}
			if (foundDataClassRef.gridManager != null)
				foundDataClassRef.gridManager.destroy();
			if (foundDataClassRef.formManager != null)
				foundDataClassRef.formManager.destroy();
			if (foundDataClassRef.queryManager != null)
				foundDataClassRef.queryManager.destroy();
			foundDataClassRef.$tabHolder.remove();
			if (foundDataClassRef.$placeHolder != null)
				foundDataClassRef.$placeHolder.remove();
			if (foundDataClassRef.split != null)
				foundDataClassRef.split.destroy();
			if (foundDataClassRef.errorManager != null)
				foundDataClassRef.errorManager.destroy();
			delete this.dataClassRefsByNames[dataclassName];
		}
		this.saveSettings();
	}

	findDataClassElemHolder(dataClassName) {
		const $result = this.$dataClassElem.find(`li[data-dataclass="${dataClassName}"]`);
		return $result;
	}

	selectDataClassElemHolder(dataClassName) {
		const $holder = this.findDataClassElemHolder(dataClassName);
		$holder.addClass('selected');
	}

	deselectDataClassElemHolder(dataClassName) {
		const $holder = this.findDataClassElemHolder(dataClassName);
		$holder.removeClass('selected');
	}

	getDataClassRef(dataclassName) {
		return this.dataClassRefsByNames[dataclassName];
	}

	buildDataClassRefs(tablist) {
		const manager = this;
		const refs = this.dataClassRefsByNames;
		tablist.forEach(tabelem => {
			let ref = refs[tabelem.dataClassName];
			const dataclass = manager.ds.getDataClass(tabelem.dataClassName);
			if (ref == null && dataclass != null) {
				const $tabHolder = this.buildTabHolder(tabelem.dataClassName);
				manager.$tabsHolder.append($tabHolder);
				ref = new DataClassRef(dataclass, null, $tabHolder);
				refs[tabelem.dataClassName] = ref;
			}
		});
	}

	async selectDataClass(dataclass) {
		const manager = this;
		// eslint-disable-next-line no-async-promise-executor
		return new Promise(async (resolve) => {
			if (dataclass == null) {
				if (this.curDataClassName != null)
					this.deselectDataClassElemHolder(this.curDataClassName);
				// this.findDataClassElemHolder();
				this.curDataClassRef = null;
				this.curDataClassName = null;
				manager.fillAttributes(null);
			} else {
				const dataclassName = dataclass.getName();
				// console.log(`startselect ${  dataclassName}`);
				if (dataclassName !== this.curDataClassName) {
					const oldname = this.curDataClassName;

					const foundDataClassRef = this.dataClassRefsByNames[dataclassName];
					if (foundDataClassRef != null && foundDataClassRef.$placeHolder != null) {
						if (this.curDataClassRef != null) {
							this.curDataClassRef.$placeHolder.hide();
							this.curDataClassRef.$tabHolder.removeClass('selected');
						}

						this.curDataClassRef = foundDataClassRef;
						this.curDataClassName = dataclassName;
						this.curDataClassRef.$tabHolder.addClass('selected');
						this.curDataClassRef.$placeHolder.show();
						manager.fillAttributes(dataclass);

					} else {

						const $placeHolder = this.$contentPlaceHolder.clone();
						this.$parentPlaceHolder.append($placeHolder);

						let $tabHolder;

						let dataclassRef = foundDataClassRef;
						if (dataclassRef == null) {
							$tabHolder = this.buildTabHolder(dataclassName);
							this.$tabsHolder.append($tabHolder);
							dataclassRef = new DataClassRef(dataclass, $placeHolder, $tabHolder);
							this.dataClassRefsByNames[dataclassName] = dataclassRef;
						} else {
							dataclassRef.$placeHolder = $placeHolder;
							$tabHolder = dataclassRef.$tabHolder;
						}

						if (this.curDataClassRef != null) {
							this.curDataClassRef.$placeHolder.hide();
							this.curDataClassRef.$tabHolder.removeClass('selected');
						}
						$tabHolder.addClass('selected');

						this.curDataClassRef = dataclassRef;
						this.curDataClassName = dataclassName;

						manager.fillAttributes(dataclass);

						const errManager = new ErrorManager(this, $placeHolder.find('.errorBar'));
						this.curDataClassRef.errorManager = errManager;
						$placeHolder.find('.dataGrid').removeClass('emptyDataGrid');
						const gridm = new GridManager(manager.ds, dataclass, $placeHolder.find('.dataGrid'), $placeHolder.find('.queryAndGrid'), $placeHolder.find('.rawDisplayFooter'), this, errManager);
						await gridm.buildGrid();
						this.curDataClassRef.gridManager = gridm;

						const formm = new FormManager(dataclass, null, 0, {
							$formContent: $placeHolder.find('.formContent'),
							$formFooter: $placeHolder.find('.formFooter'),
							$formTitle: $placeHolder.find('.formTitle'),
						}, null, gridm, errManager);
						this.curDataClassRef.formManager = formm;

						const querym = new QueryManager(dataclass, gridm, formm, $placeHolder.find('.queryDisplay'), $placeHolder.find('.queryToolBar'), errManager);
						this.curDataClassRef.queryManager = querym;

						gridm.setAssociatedManagers(formm, querym);

						dataclassRef.split = new Splitter(this, $placeHolder.find('.resizer'), $placeHolder.find('.queryAndGrid'), $placeHolder.find('.detailDisplay'), gridm);

					}

					this.curDataClassName = dataclassName;
					if (oldname != null)
						this.deselectDataClassElemHolder(oldname);
					this.selectDataClassElemHolder(this.curDataClassName);
					// console.log(`endselect ${dataclassName}`);
				}
			}
			manager.saveSettings();
			resolve();
		});
	}

	handleCloseTabEvent(event) {
		let elem = event.currentTarget;
		if (elem.getAttribute('attr-dataClassName') == null)
			elem = elem.parentElement;
		const dataclassName = elem.getAttribute('attr-dataClassName');
		let dataclass = null;
		if (dataclassName != null)
			dataclass = this.ds.getDataClass(dataclassName);
		if (dataclass != null)
			this.closeDataClass(dataclass);
		event.stopImmediatePropagation();
	}

	handleSelectTabEvent(event) {
		const elem = event.currentTarget;
		/*
		if (elem.getAttribute('attr-dataClassName') == null)
			elem = elem.parentElement;
			*/
		const dataclassName = elem.getAttribute('attr-dataClassName');
		let dataclass = null;
		if (dataclassName != null)
			dataclass = this.ds.getDataClass(dataclassName);
		if (dataclass != null) {
			this.selectDataClass(dataclass);
		}
	}

	handleDataClassEvent(event) {
		const manager = this;
		let elem = event.target;
		if (elem.getAttribute('data-dataclass') == null)
			elem = elem.parentElement;
		const dataclassName = elem.getAttribute('data-dataclass');
		let dataclass = null;
		if (dataclassName != null)
			dataclass = manager.ds.getDataClass(dataclassName);
		if (dataclass != null) {
			this.selectDataClass(dataclass);
		}
	}

	handleAttributeEvent(event) {
		const manager = this;
		let elem = event.currentTarget;
		if (elem.getAttribute('data-dataclass') == null)
			elem = elem.parentElement;
		const dataclassName = elem.getAttribute('data-dataclass');
		const attributeName = elem.getAttribute('data-attribute');
		let dataclass = null;
		if (dataclassName != null)
			dataclass = manager.ds.getDataClass(dataclassName);
		if (dataclass != null) {
			if (attributeName != null) {
				const dataClassRef = manager.getDataClassRef(dataclassName);
				if (dataClassRef != null) {
					const gridm = dataClassRef.gridManager;
					if (gridm != null) {
						const isIn = gridm.toggleAttribute(attributeName);
						if (isIn != null) {
							event.currentTarget.checked = isIn;
						}
					}
				}
			}
		}
	}

	handleDataClassFilter(event) {
		let filter = event.target.value;
		if (filter === '')
			filter = null;
		this.fillDataClasses(filter);
	}

	handleAttributeFilter(event) {
		let filter = event.target.value;
		if (filter === '')
			filter = null;
		if (this.curDataClassRef != null) {
			this.fillAttributes(this.curDataClassRef.dataclass, filter);
		}
	}

	bindEvents() {
		this.$dataClassElem.on('click', '.elemItem', this.handleDataClassEvent.bind(this));
		// this.$attributeElem.on('click', '.elemItem', this.handleAttributeEvent.bind(this));
		this.$attributeElem.on('change', '.elemItemCheck', this.handleAttributeEvent.bind(this));
		this.$inputQueryDataClass.on('input', this.handleDataClassFilter.bind(this));
		this.$inputQueryAtt.on('input', this.handleAttributeFilter.bind(this));
		this.$tabsHolder.on('click', '.dataClassTab', this.handleSelectTabEvent.bind(this));
		this.$tabsHolder.on('click', '.dataClassTab .close', this.handleCloseTabEvent.bind(this));
	}

	fillDataClasses(filter = null) {
		let html = '';
		const dataclasses = this.ds.getDataClasses();
		for (const e in dataclasses) {
			if (filter == null || Utils.stringStartsWith(e, filter)) {
				const dataclass = dataclasses[e];
				const content = `<li class="elemItem" data-dataclass="${dataclass.getName()}"><div class="elemItemText x1">${dataclass.getName()}</div></li>`;
				html += content;
			}
		}
		this.$dataClassElem.html(html);
	}

	checkAttribute(att) {
		this.$attributeElem.find(`.elemItem[data-attribute="${att.name}"] .elemItemCheck`).prop('checked', true);
	}

	fillAttributes(dataclass, filter = null) {
		let html = '';
		if (dataclass != null) {
			let displayedAtts = {};
			const dataClassRef = this.getDataClassRef(dataclass.getName());
			if (dataClassRef != null) {
				const gridm = dataClassRef.gridManager;
				if (gridm != null) {
					displayedAtts = gridm.getDisplayedAttributes();
				}
			}
			const atts = dataclass.getAllAttributes();
			for (const e in atts) {
				if (filter == null || Utils.stringStartsWith(e, filter)) {
					const att = atts[e];
					if (att.kind === 'storage' || att.kind === 'alias' || att.kind === 'calculated') {
						let iconclass = 'regular';
						if (att.identifying)
							iconclass = 'primKey';
						else if (att.indexed)
							iconclass = 'indexed';
						const isChecked = displayedAtts[att.name] ? 'checked' : '';
						let content = `<li class="elemItem" data-dataclass="${dataclass.getName()}" data-attribute="${att.name}">`;
						content += `<div class="elemItemText ${iconclass}">${att.name}</div>`;
						content += `<input type="checkbox" class="elemItemCheck" ${isChecked}>`;
						content += '</li>';

						html += content;
					}
				}
			}
		}
		this.$attributeElem.html(html);
	}

}
